﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Core.GIODO" %>
<%@ Import Namespace="Soneta.Core.UI.GIODO" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
<HEAD>
	<TITLE>Rejestr naruszeń ochrony danych osobowych</TITLE>
	<META content="C#" name="CODE_LANGUAGE">
	<META content="JavaScript" name="vs_defaultClientScript">
	<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

 <script runat="server">
     private String AdministratorDanychOsobowych {
         get {
             IPieczątkaFirmy pieczątka = ReportHeader.GetPieczątka(dc, null, false);
             return pieczątka.NazwaFormatowana + Environment.NewLine + pieczątka.Adres.Linia1 + Environment.NewLine + pieczątka.Adres.Linia2;
         }
     }

     private String InspektorDanychOsobowych {
         get {
             CoreModule core = CoreModule.GetInstance(dc);
             return core.Config.GIODO.ABI.Imię + " " + core.Config.GIODO.ABI.Nazwisko + Environment.NewLine + core.Config.GIODO.ABI.DaneKontaktowe;
         }
     }

     void OnContextLoad(Object sender, EventArgs args) {
         DataLabelAdministrator.EditValue = AdministratorDanychOsobowych;
         DataLabelInspektor.EditValue = InspektorDanychOsobowych;
         var title = "Rejestr naruszeń ochrony danych osobowych|";

         GIODONaruszeniaViewInfoParams param = null;
         if (dc.Context.Get<GIODONaruszeniaViewInfoParams>(out param)) {
             var titleDesc = "";
             if (param.ZbiorDanych!=null)
                 titleDesc += "</STRONG>Zbiór danych:<STRONG> " + param.ZbiorDanych + ", ";
             if (param.KategoriaOsob!=null)
                 titleDesc += "</STRONG>Kategoria osób:<STRONG> " + param.KategoriaOsob + ", ";
             if (param.Typ!=TypZbioruDanych.Brak)
                 titleDesc += "</STRONG>Typ zbioru:<STRONG> " + CaptionAttribute.EnumToString(param.Typ) + ", ";
             if (param.StatusNaruszenia!=GIODOStatusNaruszenia.None)
                 titleDesc += "</STRONG>Status naruszenia:<STRONG> " + CaptionAttribute.EnumToString(param.StatusNaruszenia) + ", ";
             if (param.Okres!=FromTo.All) {
                 if (param.DataNaruszeniaRodzaj==GIODODataNaruszeniaRodzaj.DataNaruszenia)
                     titleDesc += "</STRONG>Naruszenia zarejestrowane w okresie:<STRONG> " + param.Okres + ", ";
                 else if (param.DataNaruszeniaRodzaj==GIODODataNaruszeniaRodzaj.DataZgloszenia)
                     titleDesc += "</STRONG>Naruszenia zgłoszone w okresie:<STRONG> " + param.Okres + ", ";
             }
             if (param.Oddzial!=null)
                 titleDesc += "</STRONG>Oddział:<STRONG> " + param.Oddzial + ", ";
             title += titleDesc.Trim(' ').Trim(',');
         }

         ReportHeader.Title = title;
     }

     void Grid_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
         GIODONaruszenie gn = (GIODONaruszenie)args.Row;
         colDataCzasNaruszenia.EditValue = gn.DataNaruszenia + " " + ((gn.CzasNaruszenia!=Time.Zero) ? gn.CzasNaruszenia.ToString() : "");
         colDataCzasZgloszenia.EditValue = gn.DataZgloszenia + " " + ((gn.CzasZgloszenia!=Time.Zero) ? gn.CzasZgloszenia.ToString() : "");
     }

    </script>	

</HEAD>
<BODY>
	<FORM method="post" runat="server">
    <ea:datacontext id="dc" landscape="True" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
	<eb:ReportHeader id="ReportHeader" runat="server"></eb:ReportHeader>
    <br />
	<table id="Table1" cellspacing="0" cellpadding="1" width="100%" border="0" style="font-family: Tahoma; font-size: 9pt;">
        <tr>
            <td width="15%">
                Administrator danych:
            </td>
            <td width="35%">
                <ea:datalabel id="DataLabelAdministrator" runat="server" encodehtml="true"></ea:datalabel>
            </td>
            <td width="15%">
                Inspektor ochrony danych:
            </td>
            <td width="35%">
                <ea:datalabel id="DataLabelInspektor" runat="server" encodehtml="true"></ea:datalabel>
            </td>
        </tr>
    </table>
    <br />
	<ea:Grid id="Grid" rowsinrow="2" runat="server" RowTypeName="Soneta.Core.GIODO.GIODONaruszenie,Soneta.Core" OnBeforeRow="Grid_BeforeRow">
		<Columns>
			<ea:GridColumn runat="server" Width="4" Align="Center" DataMember="#" Caption="LP." RowSpan="2"></ea:GridColumn>
			<ea:GridColumn runat="server" Align="Center" DataMember="Numer" EncodeHTML="true" Caption="Numer" Width="13" RowSpan="2"></ea:GridColumn>
			<ea:GridColumn runat="server" ID="colDataCzasNaruszenia" Align="Center" EncodeHTML="true" Caption="Data naruszenia" Width="14"></ea:GridColumn>
			<ea:GridColumn runat="server" ID="colDataCzasZgloszenia" Align="Center" EncodeHTML="true" Caption="Data zgłoszenia" Width="14"></ea:GridColumn>
			<ea:GridColumn runat="server" Align="Left" DataMember="ZbiorDanych.KategoriaOsob" EncodeHTML="true" Caption="Kategorie osób" Width="25"></ea:GridColumn>									<ea:GridColumn runat="server" Align="Left" DataMember="ZbiorDanych.Nazwa" EncodeHTML="true" Caption="Nazwa zbioru danych" Width="25"></ea:GridColumn>
			<ea:GridColumn runat="server" Align="Center" DataMember="LiczbaOsob" EncodeHTML="true" Caption="Liczba osób" Width="7" RowSpan="2"></ea:GridColumn>
			<ea:GridColumn runat="server" Align="Left" DataMember="Opis" EncodeHTML="true" Caption="Charakter naruszenia" RowSpan="2"></ea:GridColumn>
			<ea:GridColumn runat="server" Align="Left" DataMember="Konsekwencje" EncodeHTML="true" Caption="Konsekwencje naruszenia" Width="25" RowSpan="2"></ea:GridColumn>
			<ea:GridColumn runat="server" Align="Left" DataMember="SrodkiZaradzenia" EncodeHTML="true" Caption="Środki zaradzenia" Width="25" RowSpan="2"></ea:GridColumn>
		</Columns>
	</ea:Grid>
    <eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
    </FORM>
	</BODY>
</HTML>
